﻿/******************************************************************************/
/*
  Project - Unity Ray Marching
            https://github.com/TheAllenChou/unity-ray-marching
  
  Author  - Ming-Lun "Allen" Chou
  Web     - http://AllenChou.net
  Twitter - @TheAllenChou
*/
/******************************************************************************/

#ifndef MUDBUN_MATH_CONST
#define MUDBUN_MATH_CONST

#define kPi          (3.1415926535)
#define kTwoPi       (6.2831853071)
#define kHalfPi      (1.5707963267)
#define kThirdPi     (1.0471975511)
#define kQuarterPi   (0.7853981633)
#define kFifthPi     (0.6283185307)
#define kSixthPi     (0.5235987755)

#define kSqrt2       (1.4142135623)
#define kSqrt3       (1.7320508075)
#define kSqrt2Inv    (0.7071067811)
#define kSqrt3Inv    (0.5773502691)

#define kEpsilon     (1e-16f)
#define kEpsilonComp (1.0f - kEpsilon)

#define kRad2Deg     (57.295779513)
#define kDeg2Rad     (0.0174532925)

#define kFltMax   (1e32f)
#define kInfinity (kFltMax)
#define kCull     (1.1e32f)

#define kCartesianNoisePeriod (8.0f)
#define kSphericalNoisePeriod (4.0f)

#endif
